%if 0%{?fedora} == 19
%global sqlitever 3.8.3
%endif
%if 0%{?fedora} == 20
%global sqlitever 3.8.10.1
%endif
%if 0%{?fedora} == 21
%global sqlitever 3.8.10.1
%endif
%if 0%{?rhel} == 6
%global sqlitever 3.6.20
%endif

Name:           spatialite-tools
Version:        4.1.1
Release:        13%{?dist}
Summary:        A set of useful CLI tools for SpatiaLite

Group:          Development/Tools
License:        GPLv3+
Source0:        http://www.gaia-gis.it/gaia-sins/%{name}-%{version}.tar.gz
URL:            https://www.gaia-gis.it/fossil/spatialite-tools

BuildRequires:  expat-devel
BuildRequires:  freexl-devel
BuildRequires:  geos-devel
BuildRequires:  libspatialite-devel
BuildRequires:  proj-devel
BuildRequires:  readline-devel
BuildRequires:  readosm-devel
BuildRequires:  sqlite-devel %{?sqlitever: = %{sqlitever}}
BuildRequires:  zlib-devel
# BZ 1048587
# The spatialite binary is a derivative of the sqlite shell and
# inherits its check for the exact same library version.
# This package thus requires a rebuild! Should be sorted out in 4.3!
Requires:  sqlite %{?sqlitever: = %{sqlitever}}

%description
Spatialite-Tools is a set of useful CLI tools for SpatiaLite.


%prep
%setup -q

# Remove unused Makefiles
rm -f Makefile-static*


%build
%configure

make %{?_smp_mflags}


%install
make install DESTDIR=%{buildroot}


%files
%doc AUTHORS COPYING
%{_bindir}/exif_loader
%{_bindir}/shp_doctor
%{_bindir}/spatialite
%{_bindir}/spatialite_convert
%{_bindir}/spatialite_dxf
%{_bindir}/spatialite_gml
%{_bindir}/spatialite_network
%{_bindir}/spatialite_osm*
%{_bindir}/spatialite_tool


%changelog
* Tue May 19 2015 Jan Stanek <jstanek@redhat.com> - 4.1.1-13
- Rebuild for sqlite 3.8.10.1

* Wed Apr 15 2015 Jan Stanek <jstanek@redhat.com> - 4.1.1-12
- Rebuild for sqlite 3.8.9

* Thu Feb 26 2015 Jan Stanek <jstanek@redhat.com> - 4.1.1-11
- Rebuild for sqlite 3.8.8.3

* Tue Jan 20 2015 Jan Stanek <jstanek@redhat.com> - 4.1.1-10
- Rebuild for sqlite 3.8.8
- Add check for the correct sqlite-devel version

* Fri Dec 12 2014 Jan Stanek <jstanek@redhat.com> - 4.1.1-9
- Rebuild for sqlite 3.8.7.4

* Tue Nov 25 2014 Jan Stanek <jstane@redhat.com> - 4.1.1-8
- Rebuild for sqlite 3.8.7.2

* Tue Oct 21 2014 Jan Stanek <jstanek@redhat.com> - 4.1.1-7
- Rebuild for sqlite 3.8.7

* Sat Aug 23 2014 Volker Fröhlich <volker27@gmx.at> - 4.1.1-6
- Rebuild for sqlite 3.8.6

* Sat Jun 14 2014 Volker Fröhlich <volker27@gmx.at> - 4.1.1-5
- Rebuild for sqlite 3.8.5

* Sun Jun 08 2014 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 4.1.1-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_21_Mass_Rebuild

* Thu Jun  5 2014 Volker Fröhlich <volker27@gmx.at> - 4.1.1-3
- Solve BZ 1048587 (spatialite command complains about sqlite version)

* Sun Aug 04 2013 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 4.1.1-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_20_Mass_Rebuild

* Mon Jul  1 2013 Volker Fröhlich <volker27@gmx.at> - 4.1.1-1
- New upstream release

* Tue Jun  4 2013 Volker Fröhlich <volker27@gmx.at> - 4.1.0-2
- Add dxf utility to files section

* Tue Jun  4 2013 Volker Fröhlich <volker27@gmx.at> - 4.1.0-1
- New upstream release

* Fri Feb 15 2013 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 4.0.0-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_19_Mass_Rebuild

* Sun Dec  2 2012 Volker Fröhlich <volker27@gmx.at> - 4.0.0-1
- New upstream release
- Remove PPC restrictions

* Sat Aug 18 2012 Volker Fröhlich <volker27@gmx.at> - 3.1.0b-1
- Update for new release
- Update URL and source URL
- Drop LDFLAG -lm
- Exclude ppc as well

* Sat Jul 21 2012 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.4.0-0.6.RC4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_18_Mass_Rebuild

* Sat Jan 14 2012 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.4.0-0.5.RC4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_17_Mass_Rebuild

* Sun Jul 17 2011 Volker Fröhlich <volker27@gmx.at> - 2.4.0-0.4.RC4
- Support readline
- Drop EPEL5 specific statements and definitions
- Drop unnecessary defattr
- Slightly improved description
- More explicit files section

* Fri Feb 25 2011 Volker Fröhlich <volker27@gmx.at> - 2.4.0-0.3.RC4
- Exclude ppc64

* Fri Jan 14 2011 Volker Fröhlich <volker27@gmx.at> - 2.4.0-0.2.RC4
- Dropped prefix from configure macro
- Corrected license
- Use macros in source URL

* Mon Dec 20 2010 Volker Fröhlich <volker27@gmx.at> - 2.4.0-0.1.RC4
- Inital packaging
